-- This will hopefully remain one of our few tables with global scope...
SRT = {}

function InitializeSRT()

	SRT = {
		-------------------------------------------------------------------
		-------------------------------------------------------------------
		-- Settings that are modified as needed.
		--
		-- the map that should currently be rendering
		ActiveMap = "Hometown",

		Transition = {
			NextMap = nil,
			NextPos = nil
		},

		Screen = {
			Width  = {
				Tiles = nil
			},
			Height = {
				Tiles = nil
			}
		},

		-- Populated with data via MapLoad()
		TileData = {},
		-- Populated with data via Overworld's default.lua
		EventData = {},


		-------------------------------------------------------------------
		-------------------------------------------------------------------
		-- Dialog System

		Dialog = {
			-- used by the InputHandler to determine whether the next START press
			-- should finish the current tweening or increment the Dialog index
			IsTweening = true,

			-- used to keep track of which line of dialog in the Words table is active
			Index = 1,

			-- an indexed table of tables, each with at least a text="" entry;
			-- some will also have choices={} entries.
			Words = nil,

			-- the color of the DialogBox's border
			BoxColor = nil,

			-- Visuals.lua always loads a DialogBox ActorFrame
			-- that has visible(false) set by default
			Box =  nil,

			-- a reference to the Cursor actor (quad) from _DialogBox.lua
			Cursor = nil,

			ChoiceIndex = 1,

			-- the name of the person speaking
			Speaker = "",
		},

		-------------------------------------------------------------------
		-------------------------------------------------------------------
		-- initialize values for the Player
		Player = {
			Name = "Stephen",
			file = "Reen",
			pos = {
				r = 38,
				d = 49,
				z = -1
			},
			dir = "Down",
			input = {
				Active = nil,
				Up = false,
				Down = false,
				Left = false,
				Right = false,
				MenuRight = false,
				MenuLeft = false,
				Start = false,
				Select = false
			}
		},


		-------------------------------------------------------------------
		-------------------------------------------------------------------
		-- Constants
		--
		-- a constant to be used to calculate animation and tween times
		-- (there is probably a better way to do this sort of thing?)
		SleepDuration = THEME:GetMetric("Overworld", "RepeatDelay"),

		-------------------------------------------------------------------
		-------------------------------------------------------------------
		-- Convenience References to Actors
		--
		-- The Overworld's primary AF has a fade in/out Quad;
		MapFade = nil,
		-- Used to pass the texture from Overworld's out to Pause's overlay
		ScreenshotTexture = nil,
		-- Populated out of Event data, on screen load
		-- used to manipulate the Actors that the events decsribe/become.
		EventActors = {},

		OverFog = nil,


		-------------------------------------------------------------------
		-------------------------------------------------------------------
		-- flags
		--
		-- Used when a dialog section is going on
		DialogIsActive = false,
		-- Used during transitions and dialog segments
		InputIsLocked = false,
		-- a (hackish) flag that can be toggled for the sake of map testing
		Collisions = true,

		-- used to check which gyms are completed
		Defeated = {
			Archi = false,
			LittleMatt = false,
			MadMatt = false
		}
	}
end

InitializeSRT()